<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|Create\InvoiceTitleCreateCmd $params)
 * @method updateByParams(array|Update\InvoiceTitleUpdateCmd $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method searchCompanyListByParams(array $params)
 * @method searchCompanyInfoByParams(array $params)
 */
class InvoiceTitle {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加发票抬头
     *
     * @var  Create\InvoiceTitleCreateCmd $invoiceTitleCreateCmd $invoiceTitleCreateCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (Create\InvoiceTitleCreateCmd $invoiceTitleCreateCmd) {
        return self::getClass()->create($invoiceTitleCreateCmd);
    }


    /**
     * 编辑发票抬头
     *
     * @var  Update\InvoiceTitleUpdateCmd $invoiceTitleUpdateCmd $invoiceTitleUpdateCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (Update\InvoiceTitleUpdateCmd $invoiceTitleUpdateCmd) {
        return self::getClass()->update($invoiceTitleUpdateCmd);
    }


    /**
     * 获取发票抬头列表
     *
     * @support  string $invoiceTitleType 抬头类型 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页条数 require false
     * @throws  \Exception
     * @return  List\InvoiceTitleListDTO
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 删除发票抬头列表
     *
     * @support  int $id 发票抬头id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 搜索发票抬头列表
     *
     * @support  string $name 发票抬头 [ require true ]
     * @throws  \Exception
     * @return  SearchCompanyList\SearchInvoiceTitleListDTO
     */
    public static function searchCompanyList () {
        return self::getClass()->searchCompanyList();
    }

    /**
     * 搜索发票抬头详情
     *
     * @support  string $code 查询发票抬头返回的code [ require true ]
     * @throws  \Exception
     * @return  SearchCompanyInfo\SearchInvoiceTitleInfoDTO
     */
    public static function searchCompanyInfo () {
        return self::getClass()->searchCompanyInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\InvoiceTitle');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\InvoiceTitle');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}