<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hotWordsByParams(array $params)
 * @method defaultWordByParams(array $params)
 * @method recommendForYouByParams(array $params)
 */
class Config {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取热门搜索
     *
     * @throws  \Exception
     * @return  HotWords\HotWordsDTO
     */
    public static function hotWords () {
        return self::getClass()->hotWords();
    }

    /**
     * 获取默认搜索词
     *
     * @throws  \Exception
     * @return  DefaultWord\DefaultWordDTO
     */
    public static function defaultWord () {
        return self::getClass()->defaultWord();
    }

    /**
     * 获取为你推荐
     *
     * @throws  \Exception
     * @return  RecommendForYou\RecommendListDTO
     */
    public static function recommendForYou () {
        return self::getClass()->recommendForYou();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Common\Config');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Common\Config');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}