<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\OrderNew;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRefundInfoByParams(array $params)
 * @method getRefundResultByParams(array $params)
 * @method getRefundAccountResultByParams(array $params)
 * @method createRefundByParams(array|CreateRefund\RefundCreateCmd $params)
 * @method updateRefundByParams(array|UpdateRefund\RefundUpdateCmd $params)
 * @method getRefundInfoV1ByParams(array $params)
 * @method getRefundResultV1ByParams(array $params)
 * @method getRefundAccountResultV1ByParams(array $params)
 * @method createRefundV1ByParams(array|CreateRefundV1\RefundCreateCmd $params)
 * @method updateRefundV1ByParams(array|UpdateRefundV1\RefundUpdateCmd $params)
 */
class Refund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得退款数据
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  GetRefundInfo\RefundDTO
     */
    public static function getRefundInfo (string $orderNo) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getRefundInfo([
                            "orderNo" => $orderNo,
                        ]),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\OrderNew\GetRefundInfo\RefundDTO"
        );
    }

    /**
     * 获得退款结果
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function getRefundResult (string $orderNo) {
        return self::getClass()->getRefundResult([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 获得退款帐号结果
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function getRefundAccountResult (string $orderNo) {
        return self::getClass()->getRefundAccountResult([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 订单退款
     *
     * @var  CreateRefund\RefundCreateCmd $command $command
     * @throws  \Exception
     * @return  bool
     */
    public static function createRefund (CreateRefund\RefundCreateCmd $command) {
        return self::getClass()->createRefund($command);
    }


    /**
     * 更新退款帐号
     *
     * @var  UpdateRefund\RefundUpdateCmd $command $command
     * @throws  \Exception
     * @return  bool
     */
    public static function updateRefund (UpdateRefund\RefundUpdateCmd $command) {
        return self::getClass()->updateRefund($command);
    }


    /**
     * 获得退款数据.v1
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  GetRefundInfoV1\RefundDTO
     */
    public static function getRefundInfoV1 (string $orderNo) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getRefundInfoV1([
                            "orderNo" => $orderNo,
                        ]),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\OrderNew\GetRefundInfoV1\RefundDTO"
        );
    }

    /**
     * 获得退款结果.v1
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function getRefundResultV1 (string $orderNo) {
        return self::getClass()->getRefundResultV1([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 获得退款帐号结果.v1
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function getRefundAccountResultV1 (string $orderNo) {
        return self::getClass()->getRefundAccountResultV1([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 订单退款.v1
     *
     * @var  CreateRefundV1\RefundCreateCmd $command $command
     * @throws  \Exception
     * @return  bool
     */
    public static function createRefundV1 (CreateRefundV1\RefundCreateCmd $command) {
        return self::getClass()->createRefundV1($command);
    }


    /**
     * 更新退款帐号.v1
     *
     * @var  UpdateRefundV1\RefundUpdateCmd $command $command
     * @throws  \Exception
     * @return  bool
     */
    public static function updateRefundV1 (UpdateRefundV1\RefundUpdateCmd $command) {
        return self::getClass()->updateRefundV1($command);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'OrderNew\Refund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'OrderNew\Refund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}