<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method actionListByParams(array|ActionList\ShootingActionCmd $params)
 * @method saveShootingActionByParams(array|SaveShootingAction\SaveShootingActionCmd $params)
 * @method editShootingActionByParams(array|EditShootingAction\SaveShootingActionCmd $params)
 * @method getShootingActionByParams(array $params)
 * @method samplePoolListByParams(array|SamplePoolList\SamplePoolCmd $params)
 */
class ShootingAction {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 拍摄动作列表
     *
     * @var  ActionList\ShootingActionCmd $shootingActionCommand $shootingActionCommand
     * @throws  \Exception
     * @return  ActionList\ShootingActionListDTO
     */
    public static function actionList (ActionList\ShootingActionCmd $shootingActionCommand) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->actionList($shootingActionCommand),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\Order\ActionList\ShootingActionListDTO"
        );
    }


    /**
     * 选定拍摄动作
     *
     * @var  SaveShootingAction\SaveShootingActionCmd $saveShootingActionCommand $saveShootingActionCommand
     * @throws  \Exception
     * @return  bool
     */
    public static function saveShootingAction (SaveShootingAction\SaveShootingActionCmd $saveShootingActionCommand) {
        return self::getClass()->saveShootingAction($saveShootingActionCommand);
    }


    /**
     * 编辑拍摄动作
     *
     * @var  EditShootingAction\SaveShootingActionCmd $saveShootingActionCommand $saveShootingActionCommand
     * @throws  \Exception
     * @return  bool
     */
    public static function editShootingAction (EditShootingAction\SaveShootingActionCmd $saveShootingActionCommand) {
        return self::getClass()->editShootingAction($saveShootingActionCommand);
    }


    /**
     * 获取订单拍摄动作
     *
     * @support  int $orderId 订单Id require false
     * @throws  \Exception
     * @return  GetShootingAction\GetShootingActionListDTO
     */
    public static function getShootingAction () {
        return self::getClass()->getShootingAction();
    }

    /**
     * 样片池妆照预览
     *
     * @var  SamplePoolList\SamplePoolCmd $command $command
     * @throws  \Exception
     * @return  SamplePoolList\SamplePoolListDTO
     */
    public static function samplePoolList (SamplePoolList\SamplePoolCmd $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->samplePoolList($command),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\Order\SamplePoolList\SamplePoolListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\ShootingAction');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\ShootingAction');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}