<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\OrderNew;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getIndexOrderByParams(array|GetIndexOrder\OrderHimoIdCmd $params)
 * @method getIndexOrderV1ByParams(array|GetIndexOrderV1\OrderHimoIdCmd $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得首页订单
     *
     * @var  GetIndexOrder\OrderHimoIdCmd $command $command
     * @throws  \Exception
     * @return  GetIndexOrder\OrderDetailDTO
     */
    public static function getIndexOrder (GetIndexOrder\OrderHimoIdCmd $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getIndexOrder($command),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\OrderNew\GetIndexOrder\OrderDetailDTO"
        );
    }


    /**
     * 获得首页订单.v1
     *
     * @var  GetIndexOrderV1\OrderHimoIdCmd $command $command
     * @throws  \Exception
     * @return  GetIndexOrderV1\OrderDetailDTO
     */
    public static function getIndexOrderV1 (GetIndexOrderV1\OrderHimoIdCmd $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getIndexOrderV1($command),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\OrderNew\GetIndexOrderV1\OrderDetailDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'OrderNew\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'OrderNew\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}