<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\OrderNew;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRefundInfoByParams(array|GetRefundInfo\RefundCommand $params)
 * @method getRefundResultByParams(array|GetRefundResult\RefundCommand $params)
 * @method createRefundByParams(array|CreateRefund\RefundCreateCommand $params)
 * @method updateRefundByParams(array|UpdateRefund\RefundUpdateCommand $params)
 * @method getSamplePoolByParams(array $params)
 * @method getRefundInfoV1ByParams(array|GetRefundInfoV1\RefundCommand $params)
 * @method getRefundResultV1ByParams(array|GetRefundResultV1\RefundCommand $params)
 * @method createRefundV1ByParams(array|CreateRefundV1\RefundCreateCommand $params)
 * @method updateRefundV1ByParams(array|UpdateRefundV1\RefundUpdateCommand $params)
 */
class Refund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得退款数据
     *
     * @var  GetRefundInfo\RefundCommand $command $command
     * @throws  \Exception
     * @return  GetRefundInfo\RefundDTO
     */
    public static function getRefundInfo (GetRefundInfo\RefundCommand $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getRefundInfo($command),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\OrderNew\GetRefundInfo\RefundDTO"
        );
    }


    /**
     * 获得退款结果
     *
     * @var  GetRefundResult\RefundCommand $command $command
     * @throws  \Exception
     * @return  bool
     */
    public static function getRefundResult (GetRefundResult\RefundCommand $command) {
        return self::getClass()->getRefundResult($command);
    }


    /**
     * 订单退款
     *
     * @var  CreateRefund\RefundCreateCommand $command $command
     * @throws  \Exception
     * @return  bool
     */
    public static function createRefund (CreateRefund\RefundCreateCommand $command) {
        return self::getClass()->createRefund($command);
    }


    /**
     * 更新退款帐号
     *
     * @var  UpdateRefund\RefundUpdateCommand $command $command
     * @throws  \Exception
     * @return  bool
     */
    public static function updateRefund (UpdateRefund\RefundUpdateCommand $command) {
        return self::getClass()->updateRefund($command);
    }


    /**
     * 妆造预览
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSamplePool () {
        return self::getClass()->getSamplePool();
    }

    /**
     * 获得退款数据.v1
     *
     * @var  GetRefundInfoV1\RefundCommand $command $command
     * @throws  \Exception
     * @return  GetRefundInfoV1\RefundDTO
     */
    public static function getRefundInfoV1 (GetRefundInfoV1\RefundCommand $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getRefundInfoV1($command),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\OrderNew\GetRefundInfoV1\RefundDTO"
        );
    }


    /**
     * 获得退款结果.v1
     *
     * @var  GetRefundResultV1\RefundCommand $command $command
     * @throws  \Exception
     * @return  bool
     */
    public static function getRefundResultV1 (GetRefundResultV1\RefundCommand $command) {
        return self::getClass()->getRefundResultV1($command);
    }


    /**
     * 订单退款.v1
     *
     * @var  CreateRefundV1\RefundCreateCommand $command $command
     * @throws  \Exception
     * @return  bool
     */
    public static function createRefundV1 (CreateRefundV1\RefundCreateCommand $command) {
        return self::getClass()->createRefundV1($command);
    }


    /**
     * 更新退款帐号.v1
     *
     * @var  UpdateRefundV1\RefundUpdateCommand $command $command
     * @throws  \Exception
     * @return  bool
     */
    public static function updateRefundV1 (UpdateRefundV1\RefundUpdateCommand $command) {
        return self::getClass()->updateRefundV1($command);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'OrderNew\Refund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'OrderNew\Refund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}