<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getReservationListByParams(array $params)
 * @method getMultiReservationListByParams(array $params)
 * @method createOrderOccupyNumByParams(array $params)
 * @method appointmentStateByParams(array $params)
 * @method getReservationListV1ByParams(array $params)
 * @method getMultiReservationListV1ByParams(array $params)
 * @method createOrderOccupyNumV1ByParams(array $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 排单表-单门店
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $dateStart 开始日期 [ require true ]
     * @param  string $dateEnd 结束日期 [ require true ]
     * @param  array $productGroup 产品数组 [ require true ]
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getReservationList (int $storeId, string $dateStart, string $dateEnd, array $productGroup, string $orderNum = '') {
        return self::getClass()->getReservationList([
            "storeId" => $storeId,
            "dateStart" => $dateStart,
            "dateEnd" => $dateEnd,
            "productGroup" => $productGroup,
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 排单表-多门店
     *
     * @param  string $dateStart 当前开始时间,当天内 [ require true ]
     * @param  string $dateEnd 当前结束时间,当天内 [ require true ]
     * @param  array $productGroup 产品数组 [ require true ]
     * @param  array $storeIds 门店 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMultiReservationList (string $dateStart, string $dateEnd, array $productGroup, array $storeIds) {
        return self::getClass()->getMultiReservationList([
            "dateStart" => $dateStart,
            "dateEnd" => $dateEnd,
            "productGroup" => $productGroup,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 校验订单是否可下单
     *
     * @support  string $reserveTime 预约时间 require false
     * @support  array $productGroup 产品数组 require false
     * @support  int $storeId 预约门店 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrderOccupyNum () {
        return self::getClass()->createOrderOccupyNum();
    }

    /**
     * 根据日期期间获取是否已约满的状态
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  array $dateRange 日期范围 [ require true ]
     * @param  array $productGroup 产品数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appointmentState (int $storeId, array $dateRange, array $productGroup) {
        return self::getClass()->appointmentState([
            "storeId" => $storeId,
            "dateRange" => $dateRange,
            "productGroup" => $productGroup,
        ]);
    }

    /**
     * 排单表-单门店.v1
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $dateStart 开始日期 [ require true ]
     * @param  string $dateEnd 结束日期 [ require true ]
     * @param  array $productGroup 产品数组 [ require true ]
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getReservationListV1 (int $storeId, string $dateStart, string $dateEnd, array $productGroup, string $orderNum = '') {
        return self::getClass()->getReservationListV1([
            "storeId" => $storeId,
            "dateStart" => $dateStart,
            "dateEnd" => $dateEnd,
            "productGroup" => $productGroup,
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 排单表-多门店.v1
     *
     * @param  string $dateStart 当前开始时间,当天内 [ require true ]
     * @param  string $dateEnd 当前结束时间,当天内 [ require true ]
     * @param  array $productGroup 产品数组 [ require true ]
     * @param  int $cityId 城市id [ require true ]
     * @param  string $storeType 门店类型，gold：金标；blue：蓝标；默认 蓝标店 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMultiReservationListV1 (string $dateStart, string $dateEnd, array $productGroup, int $cityId, string $storeType = 'blue') {
        return self::getClass()->getMultiReservationListV1([
            "dateStart" => $dateStart,
            "dateEnd" => $dateEnd,
            "productGroup" => $productGroup,
            "cityId" => $cityId,
            "storeType" => $storeType,
        ]);
    }

    /**
     * 校验订单是否可下单v1
     *
     * @support  string $reserveTime 预约时间 require false
     * @support  array $productGroup 产品数组 require false
     * @support  int $storeId 预约门店 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrderOccupyNumV1 () {
        return self::getClass()->createOrderOccupyNumV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}