<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array|Detail\StarLightDetailCommand $params)
 * @method agreeAuthorizationByParams(array|AgreeAuthorization\StarLightAgreeAuthorizationCommand $params)
 * @method authorizationNotifyByParams(array|AuthorizationNotify\AuthorizationNotifyCommand $params)
 * @method samplePoolPassNotifyByParams(array|SamplePoolPassNotify\SamplePoolPassNotifyCommand $params)
 */
class StarLight {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单下所有照片
     *
     * @var  Detail\StarLightDetailCommand $starLightDetailCommand $starLightDetailCommand
     * @throws  \Exception
     * @return  Detail\StarLightDetailDTO
     */
    public static function detail (Detail\StarLightDetailCommand $starLightDetailCommand) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->detail($starLightDetailCommand),
            "\Mainto\Bridge\Invokes\AppointmentPlatform\App\Interfaces\Controllers\User\Detail\StarLightDetailDTO"
        );
    }


    /**
     * 同意授权
     *
     * @var  AgreeAuthorization\StarLightAgreeAuthorizationCommand $starLightAgreeAuthorizationCommand $starLightAgreeAuthorizationCommand
     * @throws  \Exception
     * @return  mixed
     */
    public static function agreeAuthorization (AgreeAuthorization\StarLightAgreeAuthorizationCommand $starLightAgreeAuthorizationCommand) {
        return self::getClass()->agreeAuthorization($starLightAgreeAuthorizationCommand);
    }


    /**
     * 发送授权通知
     *
     * @var  AuthorizationNotify\AuthorizationNotifyCommand $authorizationNotifyCommand $authorizationNotifyCommand
     * @throws  \Exception
     * @return  mixed
     */
    public static function authorizationNotify (AuthorizationNotify\AuthorizationNotifyCommand $authorizationNotifyCommand) {
        return self::getClass()->authorizationNotify($authorizationNotifyCommand);
    }


    /**
     * 样片审核通过通知
     *
     * @var  SamplePoolPassNotify\SamplePoolPassNotifyCommand $samplePoolPassNotifyCommand $samplePoolPassNotifyCommand
     * @throws  \Exception
     * @return  mixed
     */
    public static function samplePoolPassNotify (SamplePoolPassNotify\SamplePoolPassNotifyCommand $samplePoolPassNotifyCommand) {
        return self::getClass()->samplePoolPassNotify($samplePoolPassNotifyCommand);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\StarLight');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\StarLight');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}