<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getShareOrderListByParams(array $params)
 * @method getShareOrderCategoriesByParams(array $params)
 * @method createShareOrderByParams(array $params)
 * @method deleteShareOrderByParams(array $params)
 * @method getShareOrderListV1ByParams(array $params)
 * @method getShareOrderCategoriesV1ByParams(array $params)
 * @method createShareOrderV1ByParams(array $params)
 * @method deleteShareOrderV1ByParams(array $params)
 */
class ShareOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得买家秀列表
     *
     * @support  int $categoryId 类目ID [ require true ]
     * @support  int $page 页数 require false
     * @support  int $pageSize 每页条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShareOrderList () {
        return self::getClass()->getShareOrderList();
    }

    /**
     * 获得晒单类目数据
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShareOrderCategories () {
        return self::getClass()->getShareOrderCategories();
    }

    /**
     * 提交晒单数据
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  array $shareData 晒单数组 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createShareOrder () {
        return self::getClass()->createShareOrder();
    }

    /**
     * 删除买家秀
     *
     * @support  int $shareId 晒单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteShareOrder () {
        return self::getClass()->deleteShareOrder();
    }

    /**
     * 获得买家秀列表.V1
     *
     * @support  int $categoryId 类目ID [ require true ]
     * @support  int $page 页数 require false
     * @support  int $pageSize 每页条数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShareOrderListV1 () {
        return self::getClass()->getShareOrderListV1();
    }

    /**
     * 获得晒单类目数据.v1
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShareOrderCategoriesV1 () {
        return self::getClass()->getShareOrderCategoriesV1();
    }

    /**
     * 提交晒单数据.V1
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  array $shareData 晒单数组 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createShareOrderV1 () {
        return self::getClass()->createShareOrderV1();
    }

    /**
     * 删除买家秀.v1
     *
     * @support  int $shareId 晒单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteShareOrderV1 () {
        return self::getClass()->deleteShareOrderV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\ShareOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\ShareOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}