<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method actionListByParams(array $params)
 * @method saveShootingActionByParams(array $params)
 * @method editShootingActionByParams(array $params)
 * @method getShootingActionByParams(array $params)
 */
class ShootingAction {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 拍摄动作列表
     *
     * @support  int $productId 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function actionList () {
        return self::getClass()->actionList();
    }

    /**
     * 选定拍摄动作
     *
     * @support  int $orderId 产品ID [ require true ]
     * @support  array $actions 所选造型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function saveShootingAction () {
        return self::getClass()->saveShootingAction();
    }

    /**
     * 编辑拍摄动作
     *
     * @support  int $orderId 产品ID [ require true ]
     * @support  array $actions 所选造型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editShootingAction () {
        return self::getClass()->editShootingAction();
    }

    /**
     * 获取订单拍摄动作
     *
     * @support  int $orderId 订单ID require false
     * @throws  \Exception
     * @return  array
     */
    public static function getShootingAction () {
        return self::getClass()->getShootingAction();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\ShootingAction');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\ShootingAction');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}