<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Question;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getNpsStatusByParams(array $params)
 * @method createNpsByParams(array $params)
 * @method getNpsStatusV1ByParams(array $params)
 * @method createNpsV1ByParams(array $params)
 */
class Nps {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取NPS状态
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNpsStatus () {
        return self::getClass()->getNpsStatus();
    }

    /**
     * 提交NPS问卷
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  int $npsAll 总分，按星级传递 1-5 [ require true ]
     * @support  int $npsReceptionist 门市客服评分 [ require true ]
     * @support  int $npsCameraman 摄影师平分 [ require true ]
     * @support  int $npsDresser 化妆师评分 [ require true ]
     * @support  int $npsRetoucher 看片师评分 [ require true ]
     * @support  string $npsNote 其他反馈 require false
     * @support  int $isShare 是否参与分享 [ require true ]
     * @support  int $retoucherCommunication 看片师沟通体验/app require false
     * @support  int $retoucherResponse 看片师响应速度/app require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createNps () {
        return self::getClass()->createNps();
    }

    /**
     * 获取NPS状态.v1
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNpsStatusV1 () {
        return self::getClass()->getNpsStatusV1();
    }

    /**
     * 提交NPS问卷.v1
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  int $npsAll 总分，按星级传递 1-5 [ require true ]
     * @support  int $npsReceptionist 门市客服评分 [ require true ]
     * @support  int $npsCameraman 摄影师平分 [ require true ]
     * @support  int $npsDresser 化妆师评分 [ require true ]
     * @support  int $npsRetoucher 看片师评分 [ require true ]
     * @support  string $npsNote 其他反馈 require false
     * @support  int $isShare 是否参与分享 [ require true ]
     * @support  int $retoucherCommunication 看片师沟通体验/app require false
     * @support  int $retoucherResponse 看片师响应速度/app require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function createNpsV1 () {
        return self::getClass()->createNpsV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Question\Nps');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Question\Nps');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}