<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method messageTestByParams(array $params)
 * @method testHookByParams(array $params)
 */
class Test {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品详情.需门店
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function messageTest () {
        return self::getClass()->messageTest();
    }

    /**
     * testHook
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function testHook () {
        return self::getClass()->testHook();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Test');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Test');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}