<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Appointment;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method appointmentLookPhotoDataByParams(array $params)
 * @method enableAppointmentTimeListByParams(array $params)
 * @method setAppointmentTimeByParams(array $params)
 * @method updateAppointmentTimeByParams(array $params)
 * @method cancelAppointmentTimeByParams(array $params)
 * @method allowLookPhotoStoreListByParams(array $params)
 * @method appointmentNeedTimeAndNoticeTimeByParams(array $params)
 */
class AppointmentLookPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预约看片首页
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appointmentLookPhotoData () {
        return self::getClass()->appointmentLookPhotoData();
    }

    /**
     * 可预约看片时间列表
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  string $dateStart 开始日期 [ require true ]
     * @support  string $dateEnd 结束日期 [ require true ]
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableAppointmentTimeList () {
        return self::getClass()->enableAppointmentTimeList();
    }

    /**
     * 设置预约看片时间
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $appointmentTime 预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setAppointmentTime () {
        return self::getClass()->setAppointmentTime();
    }

    /**
     * 更改预约看片时间
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $appointmentTime 预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateAppointmentTime () {
        return self::getClass()->updateAppointmentTime();
    }

    /**
     * 取消预约看片时间
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelAppointmentTime () {
        return self::getClass()->cancelAppointmentTime();
    }

    /**
     * 获取可看片门店
     *
     * @support  string $date 日期 [ require true ]
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  int $cityId 城市id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allowLookPhotoStoreList () {
        return self::getClass()->allowLookPhotoStoreList();
    }

    /**
     * 获取看片时长和预约通知时间
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function appointmentNeedTimeAndNoticeTime () {
        return self::getClass()->appointmentNeedTimeAndNoticeTime();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Appointment\AppointmentLookPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Appointment\AppointmentLookPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}