<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method loginByPassByParams(array $params)
 * @method loginByPassV1ByParams(array $params)
 */
class UserAuth {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户账号密码登陆
     *
     * @param  string $phone 用户手机号 [ require true ]
     * @param  string $pass 密码 [ require true ]
     * @param  string $brand 品牌ID [ require true ]
     * @param  string $tempToken 临时token [ require true ]
     * @param  string $token token验证 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByPass (string $phone, string $pass, string $brand, string $tempToken = '', string $token = '') {
        return self::getClass()->loginByPass([
            "phone" => $phone,
            "pass" => $pass,
            "brand" => $brand,
            "tempToken" => $tempToken,
            "token" => $token,
        ]);
    }

    /**
     * 用户账号密码登陆.v1
     *
     * @support  string $phone 用户手机号 [ require true ]
     * @support  string $pass 密码 [ require true ]
     * @support  string $brand 品牌ID [ require true ]
     * @support  string $temp_token 临时token require false
     * @support  string $token token验证 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByPassV1 () {
        return self::getClass()->loginByPassV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\UserAuth');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\UserAuth');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}