<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchBirthGiftByParams(array $params)
 * @method threeHourReminderByParams(array $params)
 * @method dayReminderByParams(array $params)
 * @method sendSNByParams(array $params)
 * @method precisePushByParams(array $params)
 * @method returnGiftCardByParams(array $params)
 * @method serviceCompleteByParams(array $params)
 * @method pushCompleteOrderMessageByParams(array $params)
 * @method activityNoticeByParams(array $params)
 * @method syncGeoLocationByParams(array $params)
 */
class Cron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送生日礼遇每天9-11点每5分钟执行
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchBirthGift () {
        return self::getClass()->batchBirthGift();
    }

    /**
     * 每五分钟执行一次 查询有多少用户需要发送提醒
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function threeHourReminder () {
        return self::getClass()->threeHourReminder();
    }

    /**
     * 每天11点-18点每小时执行一次 查询有多少用户需要发送提醒
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function dayReminder () {
        return self::getClass()->dayReminder();
    }

    /**
     * 每5分钟执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendSN () {
        return self::getClass()->sendSN();
    }

    /**
     * 每天晚上九点半执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function precisePush () {
        return self::getClass()->precisePush();
    }

    /**
     * 未接受礼品卡退还
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnGiftCard () {
        return self::getClass()->returnGiftCard();
    }

    /**
     * 每天10点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function serviceComplete () {
        return self::getClass()->serviceComplete();
    }

    /**
     * 每天12点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushCompleteOrderMessage () {
        return self::getClass()->pushCompleteOrderMessage();
    }

    /**
     * activityNotice
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function activityNotice () {
        return self::getClass()->activityNotice();
    }

    /**
     * 每天3点同步一次门店经纬度数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncGeoLocation () {
        return self::getClass()->syncGeoLocation();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Cron\Cron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Cron\Cron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}