<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCitiesByStoreTypeByParams(array $params)
 * @method getStoreListByCityIdByParams(array $params)
 * @method getStoreInfoByParams(array $params)
 * @method getStoreIdsHaveSameProductByParams(array $params)
 * @method getStoreIdsHaveSameProductByCityIdByParams(array $params)
 * @method getStoreListByIdsByParams(array $params)
 * @method getMostNearestStoreByParams(array $params)
 * @method getCitiesByStoreTypeV1ByParams(array $params)
 * @method getStoreListByCityIdV1ByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取当前有门店的所有城市
     *
     * @support  array $storeType 门店类型 
     * @throws  \Exception
     * @return  array
     */
    public static function getCitiesByStoreType () {
        return self::getClass()->getCitiesByStoreType();
    }

    /**
     * 根据城市id获取门店列表
     *
     * @support  array $cityIds 城市ids [ require true ]
     * @support  array $storeType 门店类型 [ require true ]
     * @support  string $type 获取数据基本类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreListByCityId () {
        return self::getClass()->getStoreListByCityId();
    }

    /**
     * 根据门店id获取门店详情
     *
     * @support  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreInfo () {
        return self::getClass()->getStoreInfo();
    }

    /**
     * 获取有该产品的门店ids
     *
     * @support  array $productIds 产品ids [ require true ]
     * @support  array $storeIds 门店 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreIdsHaveSameProduct () {
        return self::getClass()->getStoreIdsHaveSameProduct();
    }

    /**
     * 获取指定城市下拥有指定产品或类目的门店Ids
     *
     * @support  int $nodeId 产品id或者Category id [Original type uint] [ require true ]
     * @support  string $type 查询类型 [ require true ]
     * @support  int $cityId 城市id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreIdsHaveSameProductByCityId () {
        return self::getClass()->getStoreIdsHaveSameProductByCityId();
    }

    /**
     * 根绝门店ids获取门店信息
     *
     * @support  array $storeIds 门店 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreListByIds () {
        return self::getClass()->getStoreListByIds();
    }

    /**
     * 获取距离最近的门店
     *
     * @param  array $location 地理位置,[125,30] [ require true ]
     * @param  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMostNearestStore (array $location, string $brand) {
        return self::getClass()->getMostNearestStore([
            "location" => $location,
            "brand" => $brand,
        ]);
    }

    /**
     * 获取当前有门店的所有城市.v1
     *
     * @support  array $storeType 门店类型 
     * @throws  \Exception
     * @return  array
     */
    public static function getCitiesByStoreTypeV1 () {
        return self::getClass()->getCitiesByStoreTypeV1();
    }

    /**
     * 根据城市id获取门店列表.v1
     *
     * @support  array $cityIds 城市ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreListByCityIdV1 () {
        return self::getClass()->getStoreListByCityIdV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Store\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Store\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}