<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMessageListV1ByParams(array $params)
 * @method getMessageStatusByUserIdV1ByParams(array $params)
 * @method updateMessageStatusByUserIdV1ByParams(array $params)
 */
class Message {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取消息列表.v1
     *
     * @support  int $page 分页 [Original type uint] 
     * @support  int $pageSize 每页数据量 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMessageListV1 () {
        return self::getClass()->getMessageListV1();
    }

    /**
     * 获取消息状态是否未读.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMessageStatusByUserIdV1 () {
        return self::getClass()->getMessageStatusByUserIdV1();
    }

    /**
     * 更新消息状态为已读.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateMessageStatusByUserIdV1 () {
        return self::getClass()->updateMessageStatusByUserIdV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\Message');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\Message');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}