<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInvisibleCaptchaV1ByParams(array $params)
 * @method getSmsCodeWithInvisibleV1ByParams(array $params)
 */
class Notify {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * [腾讯]无痕验证.v1
     *
     * @support  string $captchaId 无痕验证应用ID，可不传，默认default 
     * @support  string $phone 手机号码 [ require true ]
     * @support  string $ticket 前端回调ticket [ require true ]
     * @support  string $randStr 前端回调randstr [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInvisibleCaptchaV1 () {
        return self::getClass()->getInvisibleCaptchaV1();
    }

    /**
     * 通过无痕验证后发送短信验证码.v1
     *
     * @param  string $type 发送类型，默认：haimati_sms_code [ require true ]
     * @param  string $phone 发送手机号码 [ require true ]
     * @param  string $token Token验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSmsCodeWithInvisibleV1 (string $type, string $phone, string $token) {
        return self::getClass()->getSmsCodeWithInvisibleV1([
            "type" => $type,
            "phone" => $phone,
            "token" => $token,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\Notify');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\Notify');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}