<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductDetailInStoreByParams(array $params)
 * @method getProductDetailByParams(array $params)
 * @method getAllProductsByParams(array $params)
 * @method getCategoryProductsByStoreIdByParams(array $params)
 * @method batchDetailByParams(array $params)
 * @method getProductsByCategoryIdsByParams(array $params)
 * @method categoriesByParams(array $params)
 * @method haveCategoryStoreIdsByParams(array $params)
 * @method getProductGiftRuleByParams(array $params)
 * @method getProductYouLikeByParams(array $params)
 * @method getAllProductsV1ByParams(array $params)
 * @method getCategoryProductsByStoreIdV1ByParams(array $params)
 * @method getProductYouLikeV1ByParams(array $params)
 * @method getProductYouLikeV2ByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品详情.需门店
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  int $productId 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductDetailInStore (int $storeId, int $productId) {
        return self::getClass()->getProductDetailInStore([
            "storeId" => $storeId,
            "productId" => $productId,
        ]);
    }

    /**
     * 获取产品详情.无需门店
     *
     * @param  int $productId 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductDetail (int $productId) {
        return self::getClass()->getProductDetail([
            "productId" => $productId,
        ]);
    }

    /**
     * 获取所有产品
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllProducts (int $storeId) {
        return self::getClass()->getAllProducts([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取一个门店下某个类目所有的产品
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategoryProductsByStoreId (int $storeId, int $categoryId) {
        return self::getClass()->getCategoryProductsByStoreId([
            "storeId" => $storeId,
            "categoryId" => $categoryId,
        ]);
    }

    /**
     * 批量获取多个产品详情
     *
     * @param  array $productIds 产品ID [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchDetail (array $productIds, int $storeId) {
        return self::getClass()->batchDetail([
            "productIds" => $productIds,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 根据类目ids获取产品
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  array $categoryIds 类目id数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsByCategoryIds (int $storeId, array $categoryIds) {
        return self::getClass()->getProductsByCategoryIds([
            "storeId" => $storeId,
            "categoryIds" => $categoryIds,
        ]);
    }

    /**
     * 根据类目ids获取类目
     *
     * @param  array $categoryIds 类目id数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function categories (array $categoryIds) {
        return self::getClass()->categories([
            "categoryIds" => $categoryIds,
        ]);
    }

    /**
     * 过滤出有该类目的门店ids
     *
     * @support  array $storeIds 门店ids,如果storeIds 传了 cityId 失效 
     * @support  int $categoryId 类目id 
     * @support  int $cityId 城市id 
     * @support  array $productIds 产品ids,如果product_ids传了category_id失效 
     * @throws  \Exception
     * @return  mixed
     */
    public static function haveCategoryStoreIds () {
        return self::getClass()->haveCategoryStoreIds();
    }

    /**
     * 获取赠品规则
     *
     * @support  int $node_id 节点ID [ require true ]
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @support  string $group 品牌分组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductGiftRule () {
        return self::getClass()->getProductGiftRule();
    }

    /**
     * 获得猜你喜欢]
     *
     * @support  string $brand 品牌标志，blue：蓝标店，gold：金标店 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductYouLike () {
        return self::getClass()->getProductYouLike();
    }

    /**
     * 获取所有产品.v1
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllProductsV1 (int $storeId) {
        return self::getClass()->getAllProductsV1([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取一个门店下某个类目所有的产品.v1
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategoryProductsByStoreIdV1 (int $storeId, int $categoryId) {
        return self::getClass()->getCategoryProductsByStoreIdV1([
            "storeId" => $storeId,
            "categoryId" => $categoryId,
        ]);
    }

    /**
     * 获得猜你喜欢.v1
     *
     * @support  array $productIds 产品ids 
     * @support  string $brand 品牌标志，blue：蓝标店，gold：金标店 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductYouLikeV1 () {
        return self::getClass()->getProductYouLikeV1();
    }

    /**
     * 获得猜你喜欢.v2
     *
     * @support  string $brand 品牌标志，blue：蓝标店，gold：金标店 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductYouLikeV2 () {
        return self::getClass()->getProductYouLikeV2();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}