<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderFillUserInfoByParams(array $params)
 * @method photoLookAppointmentSuccessNoticeByParams(array $params)
 * @method photoLookAppointmentNoticeByParams(array $params)
 * @method photoLookAppointmentInvalidNoticeByParams(array $params)
 */
class AppointmentPlatform {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户首次下单，若未填写
     *
     * @support  int $userId 用户id [ require true ]
     * @support  string $name 用户昵称 [ require true ]
     * @support  string $birth 用户生日 [ require true ]
     * @support  string $sex 用户性别 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrderFillUserInfo () {
        return self::getClass()->createOrderFillUserInfo();
    }

    /**
     * 预约看片成功通知
     *
     * @support  int $order_id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoLookAppointmentSuccessNotice () {
        return self::getClass()->photoLookAppointmentSuccessNotice();
    }

    /**
     * (大订单)预约看片提醒
     *
     * @support  int $order_id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoLookAppointmentNotice () {
        return self::getClass()->photoLookAppointmentNotice();
    }

    /**
     * 预约看片时间失效
     *
     * @support  int $order_id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoLookAppointmentInvalidNotice () {
        return self::getClass()->photoLookAppointmentInvalidNotice();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessageQueue\AppointmentPlatform');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessageQueue\AppointmentPlatform');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}