<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method encodeGroupOrderDetailByParams(array $params)
 * @method encodeRetailOrderDetailByParams(array $params)
 * @method encodeOfflineOrderDetailByParams(array $params)
 * @method getRetailOrderCodeByParams(array $params)
 */
class OrderOther {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取加密团购订单详情
     *
     * @support  string $groupOrderNum 团购订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function encodeGroupOrderDetail () {
        return self::getClass()->encodeGroupOrderDetail();
    }

    /**
     * 获取加密零售订单详情
     *
     * @support  string $encodeOrderNum 加密的零售订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function encodeRetailOrderDetail () {
        return self::getClass()->encodeRetailOrderDetail();
    }

    /**
     * 获取加密线下订单详情
     *
     * @support  string $encodeOrderNum 加密的线下订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function encodeOfflineOrderDetail () {
        return self::getClass()->encodeOfflineOrderDetail();
    }

    /**
     * 获取零售订单提货码
     *
     * @support  string $orderNo 零售订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRetailOrderCode () {
        return self::getClass()->getRetailOrderCode();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\OrderOther');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\OrderOther');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}