<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Discuss;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createArticleByParams(array $params)
 * @method editArticleByParams(array $params)
 * @method articleDetailByParams(array $params)
 * @method articleListByParams(array $params)
 * @method deleteArticleByParams(array $params)
 * @method giveLikeByParams(array $params)
 * @method imgIdentificationByParams(array $params)
 */
class ShareArticle {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * createArticle
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function createArticle () {
        return self::getClass()->createArticle();
    }

    /**
     * editArticle
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function editArticle () {
        return self::getClass()->editArticle();
    }

    /**
     * articleDetail
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function articleDetail () {
        return self::getClass()->articleDetail();
    }

    /**
     * articleList
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function articleList () {
        return self::getClass()->articleList();
    }

    /**
     * deleteArticle
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteArticle () {
        return self::getClass()->deleteArticle();
    }

    /**
     * giveLike
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function giveLike () {
        return self::getClass()->giveLike();
    }

    /**
     * imgIdentification
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function imgIdentification () {
        return self::getClass()->imgIdentification();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Discuss\ShareArticle');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Discuss\ShareArticle');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}