<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Discuss;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createArticleByParams(array $params)
 * @method editArticleByParams(array $params)
 * @method articleDetailByParams(array $params)
 * @method articleListByParams(array $params)
 * @method myArticleListByParams(array $params)
 * @method deleteArticleByParams(array $params)
 * @method giveLikeByParams(array $params)
 * @method imgIdentificationByParams(array $params)
 */
class ShareArticle {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 幸福照相馆 - 上传分享文章
     *
     * @support  string $title 标题 [ require true ]
     * @support  array $articleImgs 文章配图 [ require true ]
     * @support  string $article 文章内容 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createArticle () {
        return self::getClass()->createArticle();
    }

    /**
     * 幸福照相馆 - 编辑分享文章
     *
     * @support  int $articleId 文章ID [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  array $articleImgs 文章配图 [ require true ]
     * @support  string $article 文章内容 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editArticle () {
        return self::getClass()->editArticle();
    }

    /**
     * 幸福照相馆 - 分享文章详情
     *
     * @support  int $articleId 文章ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function articleDetail () {
        return self::getClass()->articleDetail();
    }

    /**
     * 幸福照相馆 - 分享文章列表
     *
     * @support  int $page 页码 
     * @support  int $pageSize 每页条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function articleList () {
        return self::getClass()->articleList();
    }

    /**
     * 幸福照相馆 - 我的分享文章列表
     *
     * @support  int $page 页码 
     * @support  int $pageSize 每页条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function myArticleList () {
        return self::getClass()->myArticleList();
    }

    /**
     * 幸福照相馆 - 删除分享文章
     *
     * @support  int $articleId 文章ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteArticle () {
        return self::getClass()->deleteArticle();
    }

    /**
     * 幸福照相馆 - 分享文章点赞/取消点赞
     *
     * @support  int $articleId 文章ID [ require true ]
     * @support  int $isCancel 是否取消 1：是 0：否 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function giveLike () {
        return self::getClass()->giveLike();
    }

    /**
     * 幸福照相馆 - 图片鉴别
     *
     * @support  array $imagesUrl 图片地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function imgIdentification () {
        return self::getClass()->imgIdentification();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Discuss\ShareArticle');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Discuss\ShareArticle');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}