<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method photoLookAppointmentSuccessPushByParams(array $params)
 */
class AppointmentLookPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户端-预约看片模版消息推送
     *
     * @support  int $userId 用户ID 
     * @support  string $userName 用户姓名 [ require true ]
     * @support  string $storeName 门店名称 [ require true ]
     * @support  string $address 门店地址 [ require true ]
     * @support  string $startTime 看片开始时间 [ require true ]
     * @support  string $endTime 看片结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoLookAppointmentSuccessPush () {
        return self::getClass()->photoLookAppointmentSuccessPush();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessageQueue\AppointmentLookPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessageQueue\AppointmentLookPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}