<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\ThirdParty;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createMemberByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\CloudMusic\CreateCloudMusicMemberCmd $params)
 * @method queryCreateMemberStatusByParams(array $params)
 * @method cloudMusicOrderClosedByParams(array $params)
 * @method createMemberV1ByParams(array|\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\CloudMusic\CreateCloudMusicMemberCmd $params)
 * @method queryCreateMemberStatusV1ByParams(array $params)
 */
class CloudMusic {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建云音乐会员（黑胶vip）
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\CloudMusic\CreateCloudMusicMemberCmd $createCloudMusicMemberCmd
     * @throws  \Exception
     * @return  string
     */
    public static function createMember (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\CloudMusic\CreateCloudMusicMemberCmd $createCloudMusicMemberCmd) {
        return self::getClass()->createMember($createCloudMusicMemberCmd);
    }


    /**
     * 查询云音乐兑换状态
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  int $productId 产品id [ require true ]
     * @param  int $saleSkuId 售卖的skuId [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function queryCreateMemberStatus (string $orderNum, int $productId, int $saleSkuId) {
        return self::getClass()->queryCreateMemberStatus([
            "orderNum" => $orderNum,
            "productId" => $productId,
            "saleSkuId" => $saleSkuId,
        ]);
    }

    /**
     * 关闭云音乐订单
     *
     * @param  int $cloudMusicOrderId 网易云音乐订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cloudMusicOrderClosed (int $cloudMusicOrderId) {
        return self::getClass()->cloudMusicOrderClosed([
            "cloudMusicOrderId" => $cloudMusicOrderId,
        ]);
    }

    /**
     * 创建云音乐会员v1
     *
     * @var  \Mainto\Bridge\Structs\AppointmentPlatform\Cmd\CloudMusic\CreateCloudMusicMemberCmd $createCloudMusicMemberCmd
     * @throws  \Exception
     * @return  string
     */
    public static function createMemberV1 (\Mainto\Bridge\Structs\AppointmentPlatform\Cmd\CloudMusic\CreateCloudMusicMemberCmd $createCloudMusicMemberCmd) {
        return self::getClass()->createMemberV1($createCloudMusicMemberCmd);
    }


    /**
     * 查询云音乐兑换情况v1
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  int $productId 产品id [ require true ]
     * @param  int $saleSkuId 售卖的skuId [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function queryCreateMemberStatusV1 (string $orderNum, int $productId, int $saleSkuId) {
        return self::getClass()->queryCreateMemberStatusV1([
            "orderNum" => $orderNum,
            "productId" => $productId,
            "saleSkuId" => $saleSkuId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'ThirdParty\CloudMusic');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'ThirdParty\CloudMusic');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}