<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method makeWishByParams(array $params)
 * @method getWishByParams(array $params)
 * @method drawByParams(array $params)
 * @method myPrizeByParams(array $params)
 * @method getDrawStatusByParams(array $params)
 */
class Activity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新年愿望机 - 许愿
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @support  array $wishInfo 新年愿望 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function makeWish () {
        return self::getClass()->makeWish();
    }

    /**
     * 新年愿望机 - 获取许愿
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWish () {
        return self::getClass()->getWish();
    }

    /**
     * 盲盒抽奖 - 储存奖品信息
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @support  string $prize 奖品信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function draw () {
        return self::getClass()->draw();
    }

    /**
     * 盲盒抽奖 - 我的奖品
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function myPrize () {
        return self::getClass()->myPrize();
    }

    /**
     * 盲盒抽奖 - 获取抽奖状态
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDrawStatus () {
        return self::getClass()->getDrawStatus();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Activity\Activity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Activity\Activity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}