<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchBirthGiftByParams(array $params)
 * @method occupyNumByParams(array $params)
 */
class Cron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送生日礼遇每天9-11点每5分钟执行
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchBirthGift () {
        return self::getClass()->batchBirthGift();
    }

    /**
     * 订单占点
     *
     * @support  string $createTimeStart 订单创建时间开始 [ require true ]
     * @support  string $createTimeEnd 订单创建时间结束 [ require true ]
     * @support  array $orderNos 订单创建时间结束 [ require true ]
     * @support  int $occupyNum 占点数 
     * @support  int $page page 
     * @support  int $pageSize pageSize 
     * @throws  \Exception
     * @return  mixed
     */
    public static function occupyNum () {
        return self::getClass()->occupyNum();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Cron\Cron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Cron\Cron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}