<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\GiftCard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createOrderByParams(array $params)
 * @method ownListByParams(array $params)
 * @method infoByParams(array $params)
 */
class GiftCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 礼品卡列表
     *
     * @support  int $page 分页 [Original type uint] 
     * @support  int $page_size 每页数据量 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 用户购买礼品卡
     *
     * @support  float $pay_money 实付 [Original type double] [ require true ]
     * @support  array $card_item 卡片信息 [ require true ]
     * @support  array $extend 额外信息 
     * @throws  \Exception
     * @return  array
     */
    public static function createOrder () {
        return self::getClass()->createOrder();
    }

    /**
     * 获取用户礼品卡列表
     *
     * @support  string $type 列表类型 
     * @support  string $sort_field 排序字段 
     * @support  string $sort_direction 排序方向,desc/asc 
     * @throws  \Exception
     * @return  array
     */
    public static function ownList () {
        return self::getClass()->ownList();
    }

    /**
     * 获取用户礼品卡信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function info () {
        return self::getClass()->info();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'GiftCard\GiftCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'GiftCard\GiftCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}