<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPackageByParams(array $params)
 * @method createSubPackageByParams(array $params)
 * @method upPackageByParams(array $params)
 * @method packageListByStoreByParams(array $params)
 * @method packageInfoByParams(array $params)
 * @method packageListByCategoryByParams(array $params)
 */
class ProductPackage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建套餐专区
     *
     * @support  string $name 套餐名称 [ require true ]
     * @support  string $engName 套餐英文名称 [ require true ]
     * @support  array $extend 前端拓展字段 [ require true ]
     * @support  array $metadata 后端拓展字段 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPackage () {
        return self::getClass()->createPackage();
    }

    /**
     * 创建子套餐
     *
     * @support  int $packageId 套餐专区id [ require true ]
     * @support  string $name 子套餐名称 [ require true ]
     * @support  int $occupyValue 占点 [ require true ]
     * @support  array $extend 前端拓展字段 [ require true ]
     * @support  array $metadata 后端拓展字段 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSubPackage () {
        return self::getClass()->createSubPackage();
    }

    /**
     * 上架套餐
     *
     * @support  int $id 套餐专区id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upPackage () {
        return self::getClass()->upPackage();
    }

    /**
     * 获取某家门店可展示的套餐列表
     *
     * @support  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function packageListByStore () {
        return self::getClass()->packageListByStore();
    }

    /**
     * 获取某个套餐的详情信息
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  int $packageId 套餐Id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function packageInfo () {
        return self::getClass()->packageInfo();
    }

    /**
     * 获取某个类目关联的子套餐信息
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  int $id 产品id/产品组id [ require true ]
     * @support  string $type photographyCategory/photographyProduct [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function packageListByCategory () {
        return self::getClass()->packageListByCategory();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Product\ProductPackage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Product\ProductPackage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}