<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method createGroupByParams(array $params)
 * @method closeByParams(array $params)
 * @method zeroByParams(array $params)
 * @method createV1ByParams(array $params)
 * @method closeV1ByParams(array $params)
 * @method zeroV1ByParams(array $params)
 */
class Pay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建支付
     *
     * @support  string $orderNum 订单号 
     * @support  float $payMoney 金额 [Original type unsignedDouble] [ require true ]
     * @support  string $openId 用户openId 
     * @support  array $retailOrderNum 零售订单编号数组 
     * @support  string $offlineOrderNum 线下订单编号 
     * @support  array $payOrderMoney 支付金额组合 
     * @support  int $sendUrlStaffId 发送支付链接小伙伴 
     * @support  string $payUrlCreateTime 支付链接创建时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 创建团购支付
     *
     * @support  string $groupOrderNum 订单号 
     * @support  float $payMoney 金额 [Original type unsignedDouble] [ require true ]
     * @support  string $openId 用户openId 
     * @support  int $payType 支付类型 1:支付首款 2:支付尾款 3:支付全款 [ require true ]
     * @support  int $sendUrlStaffId 发送支付链接小伙伴 
     * @support  string $payUrlCreateTime 支付链接创建时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createGroup () {
        return self::getClass()->createGroup();
    }

    /**
     * 关闭支付
     *
     * @support  string $orderNum 订单号 
     * @support  string $retailOrderNum 零售订单号 
     * @support  string $offlineOrderNum 线下订单号 
     * @support  string $groupOrderNum 团购订单号 
     * @support  int $groupOrderType 团购订单支付类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function close () {
        return self::getClass()->close();
    }

    /**
     * 零元支付
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  array $retailOrderNum 零售订单编号数组 
     * @throws  \Exception
     * @return  mixed
     */
    public static function zero () {
        return self::getClass()->zero();
    }

    /**
     * 创建支付.v1
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  float $payMoney 金额 [Original type unsignedDouble] [ require true ]
     * @support  string $openId 用户openId 
     * @support  array $retailOrderNum 零售订单编号数组 
     * @support  array $payOrderMoney 支付金额组合 
     * @throws  \Exception
     * @return  array
     */
    public static function createV1 () {
        return self::getClass()->createV1();
    }

    /**
     * 关闭支付.v1
     *
     * @support  string $orderNum 订单号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeV1 () {
        return self::getClass()->closeV1();
    }

    /**
     * 零元支付.v1
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function zeroV1 () {
        return self::getClass()->zeroV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\Pay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\Pay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}