<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bindProductCardByParams(array $params)
 * @method productCardListByParams(array $params)
 * @method availableProductCardListByParams(array $params)
 */
class ProductCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户绑定产品卡
     *
     * @support  string $productCardCode 兑换码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindProductCard () {
        return self::getClass()->bindProductCard();
    }

    /**
     * 产品卡列表
     *
     * @support  string $statusType 产品卡状态类型  
     * @support  string $status 产品卡状态 
     * @support  int $page 页数  
     * @support  int $pageSize 页码数  
     * @throws  \Exception
     * @return  mixed
     */
    public static function productCardList () {
        return self::getClass()->productCardList();
    }

    /**
     * 获取产品可用产品卡列表
     *
     * @support  array $productIds 产品id [ require true ]
     * @support  int $storeId 门店id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function availableProductCardList () {
        return self::getClass()->availableProductCardList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Preferential\ProductCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Preferential\ProductCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}