<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method packageListByStoreByParams(array $params)
 * @method packageInfoByParams(array $params)
 * @method packageListByCategoryByParams(array $params)
 * @method packageListByStoreV1ByParams(array $params)
 * @method packageInfoV1ByParams(array $params)
 * @method packageListByCategoryV1ByParams(array $params)
 */
class ProductPackage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取某家门店可展示的套餐列表
     *
     * @support  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function packageListByStore () {
        return self::getClass()->packageListByStore();
    }

    /**
     * 获取某个套餐的详情信息
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  int $packageId 套餐Id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function packageInfo () {
        return self::getClass()->packageInfo();
    }

    /**
     * 获取某个类目关联的子套餐信息
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  int $id 产品id/产品组id [ require true ]
     * @support  string $type photographyCategory/photographyProduct [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function packageListByCategory () {
        return self::getClass()->packageListByCategory();
    }

    /**
     * 获取某家门店可展示的套餐列表v1
     *
     * @support  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function packageListByStoreV1 () {
        return self::getClass()->packageListByStoreV1();
    }

    /**
     * 获取某个套餐的详情信息v1
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  int $packageId 套餐Id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function packageInfoV1 () {
        return self::getClass()->packageInfoV1();
    }

    /**
     * 获取某个类目关联的子套餐信息v1
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  int $id 产品id/产品组id [ require true ]
     * @support  string $type photographyCategory/photographyProduct [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function packageListByCategoryV1 () {
        return self::getClass()->packageListByCategoryV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Product\ProductPackage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Product\ProductPackage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}