<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bindCouponByParams(array $params)
 * @method couponListByParams(array $params)
 * @method availableCouponListByParams(array $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户绑定优惠券
     *
     * @support  string $couponCode 兑换码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindCoupon () {
        return self::getClass()->bindCoupon();
    }

    /**
     * 优惠券列表
     *
     * @support  string $statusType 优惠券状态类型  
     * @support  string $status 优惠券状态 
     * @support  int $page 页数  
     * @support  int $pageSize 页码数  
     * @throws  \Exception
     * @return  mixed
     */
    public static function couponList () {
        return self::getClass()->couponList();
    }

    /**
     * 获取产品或产品组可用优惠券列表
     *
     * @support  array $productIds 产品ids [ require true ]
     * @support  int $storeId 门店id [Original type uint] [ require true ]
     * @support  array $productGroupIds 产品组ids 
     * @throws  \Exception
     * @return  mixed
     */
    public static function availableCouponList () {
        return self::getClass()->availableCouponList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Preferential\Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Preferential\Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}