<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method infoByParams(array $params)
 * @method addByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method changeStoreByParams(array $params)
 */
class ShopCart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取购物车内容
     *
     * @support  int $cityId 城市id [ require true ]
     * @support  array $blueStoreIds 蓝标门店ids，按距离从近到远排序，越近的索引值越小 
     * @support  array $goldStoreIds 金标门店ids，按距离从近到远排序，越近的索引值越小 
     * @support  array $module 模块 
     * @support  int $storeId 手动指定门店id，需要配合module使用 
     * @throws  \Exception
     * @return  array
     */
    public static function info () {
        return self::getClass()->info();
    }

    /**
     * 添加购物车
     *
     * @support  int $cityId 城市id [ require true ]
     * @support  array $categories 选择的产品类目 
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add();
    }

    /**
     * 更新购物车所选产品
     *
     * @support  string $id 购物车选择的产品id [ require true ]
     * @support  array $category 选择的产品 [ require true ]
     * @support  int $storeId 门店id，需要获得当前门店类目下对应的价格 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除购物车所选类目
     *
     * @support  array $ids 购物车id集合 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 更新购物车的门店
     *
     * @support  int $cityId 城市id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $module 所属模块 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStore () {
        return self::getClass()->changeStore();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\ShopCart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\ShopCart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}