<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method historyByParams(array $params)
 * @method createSimpleByParams(array $params)
 * @method getInvoiceListByParams(array $params)
 * @method historyV1ByParams(array $params)
 * @method createSimpleV1ByParams(array $params)
 * @method getInvoiceListV1ByParams(array $params)
 */
class Invoice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取发票列表.历史列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function history () {
        return self::getClass()->history();
    }

    /**
     * 电子发票.开普票
     *
     * @support  array $orderNums 订单号 [ require true ]
     * @support  string $serviceType 服务类型 [ require true ]
     * @support  int $isNow 是否立即开具电子发票 [ require true ]
     * @support  string $name 购方名称 [ require true ]
     * @support  string $phone 购方手机，收验证码的手机号 
     * @support  array $detail 电子发票明细 [ require true ]
     * @support  string $message 备注信息 
     * @support  string $taxnum 购方税号(18/20位) 
     * @support  string $email 推送邮箱 
     * @support  string $telephone 购方电话 
     * @support  string $address 购方单位地址 
     * @support  string $account 购方银行账号(和开户行合在一起) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSimple () {
        return self::getClass()->createSimple();
    }

    /**
     * 获取可开票的发票列表
     *
     * @support  int $page 页数 
     * @support  int $pageSize 分页数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInvoiceList () {
        return self::getClass()->getInvoiceList();
    }

    /**
     * 获取发票列表.历史列表.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function historyV1 () {
        return self::getClass()->historyV1();
    }

    /**
     * 电子发票.开普票.v1
     *
     * @support  array $orderNums 订单号 [ require true ]
     * @support  string $serviceType 服务类型 [ require true ]
     * @support  int $isNow 是否立即开具电子发票 [ require true ]
     * @support  string $name 购方名称 [ require true ]
     * @support  string $phone 购方手机，收验证码的手机号 
     * @support  array $detail 电子发票明细 [ require true ]
     * @support  string $message 备注信息 
     * @support  string $taxnum 购方税号(18/20位) 
     * @support  string $email 推送邮箱 
     * @support  string $telephone 购方电话 
     * @support  string $address 购方单位地址 
     * @support  string $account 购方银行账号(和开户行合在一起) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSimpleV1 () {
        return self::getClass()->createSimpleV1();
    }

    /**
     * 获取可开票的发票列表.v1
     *
     * @support  int $page 页数 
     * @support  int $pageSize 分页数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInvoiceListV1 () {
        return self::getClass()->getInvoiceListV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\Invoice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\Invoice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}