<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getBirthGiftByParams(array $params)
 * @method exchangeBirthGiftByParams(array $params)
 * @method upgradeUserMemberTypeByParams(array $params)
 * @method listWelfareByParams(array $params)
 * @method listMemberActivitiesByParams(array $params)
 * @method getUserMilestonesByParams(array $params)
 * @method receiveMilestoneByParams(array $params)
 * @method getUserPointRecordsByParams(array $params)
 * @method getBirthGiftV1ByParams(array $params)
 * @method exchangeBirthGiftV1ByParams(array $params)
 * @method upgradeUserMemberTypeV1ByParams(array $params)
 * @method listWelfareV1ByParams(array $params)
 * @method listMemberActivitiesV1ByParams(array $params)
 * @method getUserMilestonesV1ByParams(array $params)
 * @method receiveMilestoneV1ByParams(array $params)
 * @method getUserPointRecordsV1ByParams(array $params)
 */
class UserMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户获取生日礼遇零售产品
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getBirthGift () {
        return self::getClass()->getBirthGift();
    }

    /**
     * 兑换生日礼遇
     *
     * @support  int $orderId 预约订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exchangeBirthGift () {
        return self::getClass()->exchangeBirthGift();
    }

    /**
     * 升级会员为新会员类型
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function upgradeUserMemberType () {
        return self::getClass()->upgradeUserMemberType();
    }

    /**
     * 获取会员权益
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function listWelfare () {
        return self::getClass()->listWelfare();
    }

    /**
     * 会员活动列表
     *
     * @support  array $types 活动类型, banner banner图, user_related 用户相关, 默认查询所有类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function listMemberActivities () {
        return self::getClass()->listMemberActivities();
    }

    /**
     * 用户里程碑信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserMilestones () {
        return self::getClass()->getUserMilestones();
    }

    /**
     * 领取里程碑奖励
     *
     * @support  int $id 里程碑 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveMilestone () {
        return self::getClass()->receiveMilestone();
    }

    /**
     * 获取用户纪念值记录
     *
     * @support  int $page 页数 
     * @support  int $pageSize 分页数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserPointRecords () {
        return self::getClass()->getUserPointRecords();
    }

    /**
     * 用户获取生日礼遇零售产品.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBirthGiftV1 () {
        return self::getClass()->getBirthGiftV1();
    }

    /**
     * 兑换生日礼遇.v1
     *
     * @support  int $orderId 预约订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exchangeBirthGiftV1 () {
        return self::getClass()->exchangeBirthGiftV1();
    }

    /**
     * 升级会员为新会员类型.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function upgradeUserMemberTypeV1 () {
        return self::getClass()->upgradeUserMemberTypeV1();
    }

    /**
     * 获取会员权益.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function listWelfareV1 () {
        return self::getClass()->listWelfareV1();
    }

    /**
     * 会员活动列表.v1
     *
     * @support  array $types 活动类型, banner banner图, user_related 用户相关, 默认查询所有类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function listMemberActivitiesV1 () {
        return self::getClass()->listMemberActivitiesV1();
    }

    /**
     * 用户里程碑信息.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserMilestonesV1 () {
        return self::getClass()->getUserMilestonesV1();
    }

    /**
     * 领取里程碑奖励.v1
     *
     * @support  int $id 里程碑 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveMilestoneV1 () {
        return self::getClass()->receiveMilestoneV1();
    }

    /**
     * 获取用户纪念值记录.v1
     *
     * @support  int $page 页数 
     * @support  int $pageSize 分页数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserPointRecordsV1 () {
        return self::getClass()->getUserPointRecordsV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\UserMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\UserMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}