<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderClothByParams(array $params)
 * @method getMyChooseClothByParams(array $params)
 * @method saveChooseClothByParams(array $params)
 */
class OrderCloth {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单拍前衣服
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderCloth (string $orderNo) {
        return self::getClass()->getOrderCloth([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 获取我的选衣图片
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMyChooseCloth (string $orderNo) {
        return self::getClass()->getMyChooseCloth([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 提交选择的选衣照片
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @support  array $clothes 图片数组 
     * @support  string $upper 上衣 
     * @support  string $lower 下装 
     * @support  string $career 职业 
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveChooseCloth () {
        return self::getClass()->saveChooseCloth();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\OrderCloth');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\OrderCloth');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}