<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method editUserInfoByParams(array $params)
 * @method getProfessionsByParams(array $params)
 * @method getPreferencesByParams(array $params)
 * @method detailV1ByParams(array $params)
 * @method getProfessionsV1ByParams(array $params)
 * @method getPreferencesV1ByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户详情
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 修改用户信息
     *
     * @support  string $name 用户昵称 
     * @support  string $headSculpture 用户头像 
     * @support  string $birth 用户生日 
     * @support  string $sex 用户性别 
     * @support  int $position 职位id 
     * @support  string $city 城市编号 
     * @support  string $email 邮箱 
     * @support  string $preference 偏好 
     * @support  string $purpose 用途 
     * @support  bool $receivePush 接受推送 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editUserInfo () {
        return self::getClass()->editUserInfo();
    }

    /**
     * 职业列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProfessions () {
        return self::getClass()->getProfessions();
    }

    /**
     * 偏好列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPreferences () {
        return self::getClass()->getPreferences();
    }

    /**
     * 用户详情.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function detailV1 () {
        return self::getClass()->detailV1();
    }

    /**
     * 职业列表.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProfessionsV1 () {
        return self::getClass()->getProfessionsV1();
    }

    /**
     * 偏好列表.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPreferencesV1 () {
        return self::getClass()->getPreferencesV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}