<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkBirthGiftByParams(array $params)
 * @method exchangeBirthGiftByParams(array $params)
 * @method upgradeUserMemberTypeByParams(array $params)
 * @method listWelfareByParams(array $params)
 * @method listMemberActivitiesByParams(array $params)
 * @method listUserBrandsByParams(array $params)
 * @method getUserMilestonesByParams(array $params)
 * @method receiveMilestoneByParams(array $params)
 * @method getUserPointRecordsByParams(array $params)
 * @method getUserMilestonesV1ByParams(array $params)
 */
class UserMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户是否可兑换生日礼遇
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkBirthGift () {
        return self::getClass()->checkBirthGift();
    }

    /**
     * 兑换生日礼遇
     *
     * @support  int $orderId 预约订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exchangeBirthGift () {
        return self::getClass()->exchangeBirthGift();
    }

    /**
     * 升级会员为新会员类型
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function upgradeUserMemberType () {
        return self::getClass()->upgradeUserMemberType();
    }

    /**
     * 获取会员权益
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function listWelfare () {
        return self::getClass()->listWelfare();
    }

    /**
     * 会员活动列表
     *
     * @support  string $type 活动类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function listMemberActivities () {
        return self::getClass()->listMemberActivities();
    }

    /**
     * 获取用户品牌信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function listUserBrands () {
        return self::getClass()->listUserBrands();
    }

    /**
     * 用户里程碑信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserMilestones () {
        return self::getClass()->getUserMilestones();
    }

    /**
     * 领取里程碑奖励
     *
     * @support  int $id 里程碑 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveMilestone () {
        return self::getClass()->receiveMilestone();
    }

    /**
     * 获取用户纪念值
     *
     * @support  int $page 页数 
     * @support  int $pageSize 分页数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserPointRecords () {
        return self::getClass()->getUserPointRecords();
    }

    /**
     * 用户里程碑信息.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserMilestonesV1 () {
        return self::getClass()->getUserMilestonesV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\UserMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\UserMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}