<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getBirthGiftByParams(array $params)
 * @method exchangeBirthGiftByParams(array $params)
 * @method setMemberUpgradeTagByParams(array $params)
 * @method alertCheckByParams(array $params)
 * @method listWelfareByParams(array $params)
 * @method listMemberActivitiesByParams(array $params)
 * @method receivePointsByParams(array $params)
 * @method getUserMilestonesByParams(array $params)
 * @method receiveMilestoneByParams(array $params)
 * @method receiveWelfareRetailByParams(array $params)
 * @method exchangeMilestoneRetailByParams(array $params)
 * @method getUserPointRecordsByParams(array $params)
 * @method getUserBrandsByParams(array $params)
 * @method changeMemberLevelByParams(array $params)
 * @method joinUserMemberByParams(array $params)
 * @method changeMemberPointsByParams(array $params)
 * @method sendMemberCouponByParams(array $params)
 * @method getBirthGiftV1ByParams(array $params)
 * @method exchangeBirthGiftV1ByParams(array $params)
 * @method setMemberUpgradeTagV1ByParams(array $params)
 * @method alertCheckV1ByParams(array $params)
 * @method listWelfareV1ByParams(array $params)
 * @method listMemberActivitiesV1ByParams(array $params)
 * @method getUserMilestonesV1ByParams(array $params)
 * @method receiveMilestoneV1ByParams(array $params)
 * @method receiveWelfareRetailV1ByParams(array $params)
 * @method exchangeMilestoneRetailV1ByParams(array $params)
 * @method getUserPointRecordsV1ByParams(array $params)
 * @method getUserBrandsV1ByParams(array $params)
 */
class UserMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户获取生日礼遇零售产品
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getBirthGift () {
        return self::getClass()->getBirthGift();
    }

    /**
     * 兑换生日礼遇
     *
     * @support  int $orderId 预约订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exchangeBirthGift () {
        return self::getClass()->exchangeBirthGift();
    }

    /**
     * 添加新版会员弹框记录
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setMemberUpgradeTag () {
        return self::getClass()->setMemberUpgradeTag();
    }

    /**
     * 删除会员升级弹框标记
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function alertCheck () {
        return self::getClass()->alertCheck();
    }

    /**
     * 获取会员权益
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function listWelfare () {
        return self::getClass()->listWelfare();
    }

    /**
     * 会员活动列表
     *
     * @support  array $types 活动类型, banner banner图, user_related 用户相关, 默认查询所有类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function listMemberActivities () {
        return self::getClass()->listMemberActivities();
    }

    /**
     * 领取积分
     *
     * @support  int $userId 用户id [ require true ]
     * @support  string $type 活动类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receivePoints () {
        return self::getClass()->receivePoints();
    }

    /**
     * 用户里程碑信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserMilestones () {
        return self::getClass()->getUserMilestones();
    }

    /**
     * 领取里程碑奖励
     *
     * @support  int $id 里程碑 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveMilestone () {
        return self::getClass()->receiveMilestone();
    }

    /**
     * 领取权益美学生活礼遇
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveWelfareRetail () {
        return self::getClass()->receiveWelfareRetail();
    }

    /**
     * 兑换里程碑零售产品
     *
     * @support  int $milestoneId 里程碑id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exchangeMilestoneRetail () {
        return self::getClass()->exchangeMilestoneRetail();
    }

    /**
     * 获取用户纪念值记录
     *
     * @support  int $page 页数 
     * @support  int $pageSize 分页数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserPointRecords () {
        return self::getClass()->getUserPointRecords();
    }

    /**
     * 获取用户品牌探索标签
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserBrands () {
        return self::getClass()->getUserBrands();
    }

    /**
     * 会员升级hook
     *
     * @support  int $userId 用户id 
     * @support  string $change 升降级类型 
     * @support  string $originLevel 原等级 
     * @support  string $currentLevel 当前等级 
     * @support  bool $isReview 是否为复审 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeMemberLevel () {
        return self::getClass()->changeMemberLevel();
    }

    /**
     * 加入会员hook
     *
     * @support  int $userId 用户id 
     * @support  string $currentLevel 当前等级 
     * @throws  \Exception
     * @return  mixed
     */
    public static function joinUserMember () {
        return self::getClass()->joinUserMember();
    }

    /**
     * 积分变更hook
     *
     * @support  int $userId 用户id 
     * @support  string $type 类型 
     * @support  int $outId 外部关联id 
     * @support  float $points 积分 [Original type double] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeMemberPoints () {
        return self::getClass()->changeMemberPoints();
    }

    /**
     * 发送会员加修加印券hook
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendMemberCoupon (int $orderId, int $userId = 0) {
        return self::getClass()->sendMemberCoupon([
            "orderId" => $orderId,
            "userId" => $userId,
        ]);
    }

    /**
     * 用户获取生日礼遇零售产品.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBirthGiftV1 () {
        return self::getClass()->getBirthGiftV1();
    }

    /**
     * 兑换生日礼遇.v1
     *
     * @support  int $orderId 预约订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exchangeBirthGiftV1 () {
        return self::getClass()->exchangeBirthGiftV1();
    }

    /**
     * 添加新版会员弹框记录.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setMemberUpgradeTagV1 () {
        return self::getClass()->setMemberUpgradeTagV1();
    }

    /**
     * 删除会员升级弹框标记.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function alertCheckV1 () {
        return self::getClass()->alertCheckV1();
    }

    /**
     * 获取会员权益.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function listWelfareV1 () {
        return self::getClass()->listWelfareV1();
    }

    /**
     * 会员活动列表.v1
     *
     * @support  array $types 活动类型, banner banner图, user_related 用户相关, 默认查询所有类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function listMemberActivitiesV1 () {
        return self::getClass()->listMemberActivitiesV1();
    }

    /**
     * 用户里程碑信息.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserMilestonesV1 () {
        return self::getClass()->getUserMilestonesV1();
    }

    /**
     * 领取里程碑奖励.v1
     *
     * @support  int $id 里程碑 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveMilestoneV1 () {
        return self::getClass()->receiveMilestoneV1();
    }

    /**
     * 领取权益美学生活礼遇.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveWelfareRetailV1 () {
        return self::getClass()->receiveWelfareRetailV1();
    }

    /**
     * 兑换里程碑零售产品.v1
     *
     * @support  int $milestoneId 里程碑id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exchangeMilestoneRetailV1 () {
        return self::getClass()->exchangeMilestoneRetailV1();
    }

    /**
     * 获取用户纪念值记录.v1
     *
     * @support  int $page 页数 
     * @support  int $pageSize 分页数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserPointRecordsV1 () {
        return self::getClass()->getUserPointRecordsV1();
    }

    /**
     * 获取用户品牌探索标签.v1
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserBrandsV1 () {
        return self::getClass()->getUserBrandsV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\UserMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\UserMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}