<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listPhotoAlbumsByParams(array $params)
 * @method createSharePhotoRecordByParams(array $params)
 * @method updateSharePhotoRecordByParams(array $params)
 * @method getShareRecordDetailByParams(array $params)
 * @method saveSharePhotosByParams(array $params)
 * @method listPhotoAlbumsV1ByParams(array $params)
 * @method createSharePhotoRecordV1ByParams(array $params)
 * @method getShareRecordDetailV1ByParams(array $params)
 * @method saveSharePhotosV1ByParams(array $params)
 */
class PhotoAlbum {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 我的相册
     *
     * @support  int $page 页码 
     * @support  int $pageSize 分页数 
     * @support  string $lastOrderReserveTime 上一页最后预约时间 
     * @throws  \Exception
     * @return  array
     */
    public static function listPhotoAlbums () {
        return self::getClass()->listPhotoAlbums();
    }

    /**
     * 相册分享记录.创建
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  array $photos 分享的图片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSharePhotoRecord () {
        return self::getClass()->createSharePhotoRecord();
    }

    /**
     * 相册分享记录.更新
     *
     * @support  int $shareType 分享类型 1:普通共享 2:指定共享 [ require true ]
     * @support  array $whitePhones 指定共享的手机号 
     * @support  string $shareRecordId 待更新的分享记录id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateSharePhotoRecord () {
        return self::getClass()->updateSharePhotoRecord();
    }

    /**
     * 分享记录详情
     *
     * @support  string $shareRecordId 分享记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShareRecordDetail () {
        return self::getClass()->getShareRecordDetail();
    }

    /**
     * 保存分享数据到我的相册
     *
     * @support  string $shareRecordId 分享记录id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function saveSharePhotos () {
        return self::getClass()->saveSharePhotos();
    }

    /**
     * 我的相册.v1
     *
     * @support  int $page 页码 
     * @support  int $pageSize 分页数 
     * @support  string $lastOrderReserveTime 上一页最后预约时间 
     * @throws  \Exception
     * @return  array
     */
    public static function listPhotoAlbumsV1 () {
        return self::getClass()->listPhotoAlbumsV1();
    }

    /**
     * 相册分享记录.创建.v1
     *
     * @support  string $orderNum 订单编号 [ require true ]
     * @support  array $photos 分享的图片信息 [ require true ]
     * @support  int $shareType 分享类型，1为普通共享，2为指定共享 
     * @support  array $whitePhones 手机号数据 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSharePhotoRecordV1 () {
        return self::getClass()->createSharePhotoRecordV1();
    }

    /**
     * 分享记录详情.v1
     *
     * @support  string $shareRecordId 分享记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShareRecordDetailV1 () {
        return self::getClass()->getShareRecordDetailV1();
    }

    /**
     * 保存分享数据到我的相册.v1
     *
     * @support  string $shareRecordId 分享记录id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function saveSharePhotosV1 () {
        return self::getClass()->saveSharePhotosV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\PhotoAlbum');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\PhotoAlbum');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}