<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Christmas;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkUserJoinInfoByParams(array $params)
 * @method getChristPhotoByParams(array $params)
 * @method createChristmasActivityByParams(array $params)
 * @method christmasActivityInfoByParams(array $params)
 * @method updateChristmasActivityByParams(array $params)
 * @method submitChristmasActivityByParams(array $params)
 * @method testByParams(array $params)
 * @method getSaleOrderCountByParams(array $params)
 * @method getSaleOrderCountV1ByParams(array $params)
 */
class Christmas {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户参加详情
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkUserJoinInfo () {
        return self::getClass()->checkUserJoinInfo();
    }

    /**
     * 获取用户本年度拍摄的圣诞照照片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getChristPhoto () {
        return self::getClass()->getChristPhoto();
    }

    /**
     * 创建成团
     *
     * @support  string $headerOrderNum 团长订单号 [ require true ]
     * @support  string $type 活动类型:one,many [ require true ]
     * @support  int $peopleNum 成团人数 [ require true ]
     * @support  array $memberInfo 成团人数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createChristmasActivity () {
        return self::getClass()->createChristmasActivity();
    }

    /**
     * 成团活动详情
     *
     * @support  string $id  [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function christmasActivityInfo () {
        return self::getClass()->christmasActivityInfo();
    }

    /**
     * 修改圣诞成团活动
     *
     * @support  string $id 团长订单号 [ require true ]
     * @support  int $peopleNum 成团人数 
     * @support  array $memberInfo 成团人数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateChristmasActivity () {
        return self::getClass()->updateChristmasActivity();
    }

    /**
     * 立即成团
     *
     * @support  string $id 圣诞照活动id [ require true ]
     * @support  int $peopleNum 成团修改人数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitChristmasActivity () {
        return self::getClass()->submitChristmasActivity();
    }

    /**
     * 测试
     *
     * @support  int $userId 用户id [ require true ]
     * @support  string $headerOrderNum 用户订单编号 [ require true ]
     * @support  string $type 用户类型 [ require true ]
     * @support  int $peopleNum 参团人数 [ require true ]
     * @support  string $status 参团状态 [ require true ]
     * @support  array $memberInfo 参团照片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function test () {
        return self::getClass()->test();
    }

    /**
     * 获得某日圣诞照的销售数量
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSaleOrderCount (int $storeId, string $date) {
        return self::getClass()->getSaleOrderCount([
            "storeId" => $storeId,
            "date" => $date,
        ]);
    }

    /**
     * 获得某日圣诞照的销售数量.v1
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSaleOrderCountV1 (int $storeId, string $date) {
        return self::getClass()->getSaleOrderCountV1([
            "storeId" => $storeId,
            "date" => $date,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Christmas\Christmas');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Christmas\Christmas');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}