<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSaleOrderCountByParams(array $params)
 * @method getUserConsumeStoreIdsByParams(array $params)
 * @method getSaleOrderCountV1ByParams(array $params)
 * @method getUserConsumeStoreIdsV1ByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得某日产品的销售数量
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  string $date 日期 [ require true ]
     * @support  array $productIds 产品ids数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSaleOrderCount () {
        return self::getClass()->getSaleOrderCount();
    }

    /**
     * 用户消费门店
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserConsumeStoreIds () {
        return self::getClass()->getUserConsumeStoreIds();
    }

    /**
     * 获得某日产品的销售数量.v1
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  string $date 日期 [ require true ]
     * @support  array $productIds 产品ids数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSaleOrderCountV1 () {
        return self::getClass()->getSaleOrderCountV1();
    }

    /**
     * 用户消费门店.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserConsumeStoreIdsV1 () {
        return self::getClass()->getUserConsumeStoreIdsV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}