<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Christmas;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkUserJoinInfoByParams(array $params)
 * @method getChristPhotoByParams(array $params)
 * @method createChristmasActivityByParams(array $params)
 * @method christmasActivityInfoByParams(array $params)
 * @method updateChristmasActivityByParams(array $params)
 * @method submitChristmasActivityByParams(array $params)
 * @method testByParams(array $params)
 */
class Christmas {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户参加详情
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkUserJoinInfo () {
        return self::getClass()->checkUserJoinInfo();
    }

    /**
     * 获取用户本年度拍摄的圣诞照照片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getChristPhoto () {
        return self::getClass()->getChristPhoto();
    }

    /**
     * 创建成团
     *
     * @support  string $headerOrderNum 团长订单号 [ require true ]
     * @support  string $type 活动类型:one,many [ require true ]
     * @support  int $people_num 成团人数 [ require true ]
     * @support  array $member_info 成团人数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createChristmasActivity () {
        return self::getClass()->createChristmasActivity();
    }

    /**
     * 成团活动详情
     *
     * @support  string $id  [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function christmasActivityInfo () {
        return self::getClass()->christmasActivityInfo();
    }

    /**
     * 修改圣诞成团活动
     *
     * @support  string $id 团长订单号 [ require true ]
     * @support  int $people_num 成团人数 
     * @support  array $member_info 成团人数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateChristmasActivity () {
        return self::getClass()->updateChristmasActivity();
    }

    /**
     * 立即成团
     *
     * @support  string $id 圣诞照活动id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitChristmasActivity () {
        return self::getClass()->submitChristmasActivity();
    }

    /**
     * 测试
     *
     * @support  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function test () {
        return self::getClass()->test();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Christmas\Christmas');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Christmas\Christmas');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}