<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\MessgaeQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method autoCreatedFinishedPhotoByParams(array $params)
 */
class CloudOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 圣诞节活动自动创建finishPhoto:回调
     *
     * @support  string $stream_num 云端流水编号 [ require true ]
     * @support  string $order_num 订单编号 [ require true ]
     * @support  array $photo_data 图片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoCreatedFinishedPhoto () {
        return self::getClass()->autoCreatedFinishedPhoto();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'MessgaeQueue\CloudOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'MessgaeQueue\CloudOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}