<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getReservationListByParams(array $params)
 * @method getMultiReservationListByParams(array $params)
 * @method getReservationListV1ByParams(array $params)
 * @method getMultiReservationListV1ByParams(array $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 排单表-单门店
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  string $dateStart 开始日期 [ require true ]
     * @support  string $dateEnd 结束日期 [ require true ]
     * @support  array $productGroup 产品数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getReservationList () {
        return self::getClass()->getReservationList();
    }

    /**
     * 排单表-多门店
     *
     * @support  string $date 当前日期 [ require true ]
     * @support  string $time 当前时间点,如：11:00 
     * @support  string $timeZone 时间段，上午 morning，下午 afternoon，晚上 night 
     * @support  array $productGroup 产品数组 [ require true ]
     * @support  array $storeIds 门店 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMultiReservationList () {
        return self::getClass()->getMultiReservationList();
    }

    /**
     * 排单表-单门店.v1
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  string $dateStart 开始日期 [ require true ]
     * @support  string $dateEnd 结束日期 [ require true ]
     * @support  array $productGroup 产品数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getReservationListV1 () {
        return self::getClass()->getReservationListV1();
    }

    /**
     * 排单表-多门店.v1
     *
     * @support  string $date 当前日期 [ require true ]
     * @support  string $time 当前时间点,如：11:00 
     * @support  string $timeZone 时间段，上午 morning，下午 afternoon，晚上 night 
     * @support  array $productGroup 产品数组 [ require true ]
     * @support  int $cityId 城市id [ require true ]
     * @support  string $storeType 门店类型，gold：金标；blue：蓝标；默认 蓝标店 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMultiReservationListV1 () {
        return self::getClass()->getMultiReservationListV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}