<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllProductsByParams(array $params)
 * @method getCategoryProductsByStoreIdByParams(array $params)
 * @method getAllProductsV1ByParams(array $params)
 * @method getCategoryProductsByStoreIdV1ByParams(array $params)
 * @method getProductYouLikeV1ByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有产品
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllProducts (int $storeId) {
        return self::getClass()->getAllProducts([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取一个门店下某个类目所有的产品
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategoryProductsByStoreId (int $storeId, int $categoryId) {
        return self::getClass()->getCategoryProductsByStoreId([
            "storeId" => $storeId,
            "categoryId" => $categoryId,
        ]);
    }

    /**
     * 获取所有产品.v1
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllProductsV1 (int $storeId) {
        return self::getClass()->getAllProductsV1([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取一个门店下某个类目所有的产品.v1
     *
     * @param  int $categoryId 类目 [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategoryProductsByStoreIdV1 (int $storeId, int $categoryId) {
        return self::getClass()->getCategoryProductsByStoreIdV1([
            "storeId" => $storeId,
            "categoryId" => $categoryId,
        ]);
    }

    /**
     * 获得猜你喜欢.v1
     *
     * @support  array $productIds 产品ids 
     * @support  string $brand 品牌标志，blue：蓝标店，gold：金标店 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductYouLikeV1 () {
        return self::getClass()->getProductYouLikeV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}