<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSnStatusByParams(array $params)
 * @method getSnQuestionByParams(array $params)
 * @method getNpsStatusByParams(array $params)
 * @method createSnByParams(array $params)
 * @method createNpsByParams(array $params)
 */
class Nps {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取SN状态
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSnStatus () {
        return self::getClass()->getSnStatus();
    }

    /**
     * 获取SN问卷
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSnQuestion () {
        return self::getClass()->getSnQuestion();
    }

    /**
     * 获取NPS状态
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNpsStatus () {
        return self::getClass()->getNpsStatus();
    }

    /**
     * 提交SN问卷
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  array $answers 答案组 [ require true ]
     * @support  string $note sn意见 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSn () {
        return self::getClass()->createSn();
    }

    /**
     * 提交NPS问卷
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  int $npsAll 总分，按星级传递 1-5 [ require true ]
     * @support  int $npsReceptionist 门市客服评分 [ require true ]
     * @support  int $npsCameraman 摄影师平分 [ require true ]
     * @support  int $npsDresser 化妆师评分 [ require true ]
     * @support  int $npsRetoucher 看片师评分 [ require true ]
     * @support  string $npsNote 其他反馈 
     * @support  int $isShare 是否参与分享 [ require true ]
     * @support  int $retoucherCommunication 看片师沟通体验/app 
     * @support  int $retoucherResponse 看片师响应速度/app 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createNps () {
        return self::getClass()->createNps();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'User\Nps');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'User\Nps');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}