<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatform\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderByParams(array $params)
 * @method detailByParams(array $params)
 * @method groupOrderDetailByParams(array $params)
 * @method encodeOrderDetailByParams(array $params)
 * @method listByParams(array $params)
 * @method cancelByParams(array $params)
 * @method deleteByParams(array $params)
 * @method bindUserByParams(array $params)
 * @method refundByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method checkProductCalcByParams(array $params)
 * @method getRefundReasonByParams(array $params)
 * @method sendOrderShareCouponByParams(array $params)
 * @method createOrderV1ByParams(array $params)
 * @method detailV1ByParams(array $params)
 * @method listV1ByParams(array $params)
 * @method cancelV1ByParams(array $params)
 * @method deleteV1ByParams(array $params)
 * @method refundV1ByParams(array $params)
 * @method changeReserveTimeV1ByParams(array $params)
 * @method getRefundReasonV1ByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  string $userName 用户姓名 [ require true ]
     * @support  string $userPhone 用户手机号 [ require true ]
     * @support  string $userBirthday 用户生日 [ require true ]
     * @support  string $userSex 用户性别 [ require true ]
     * @support  string $userEmail 用户邮箱 
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  int $couponId 优惠券ID 
     * @support  float $couponDeductionMoney 优惠券优惠金额 [Original type unsignedDouble] 
     * @support  float $giftCardMoney 礼品卡抵扣金额 [Original type double] 
     * @support  float $oriMoney 原始价格 [Original type unsignedDouble] [ require true ]
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡优惠金额 [Original type unsignedDouble] 
     * @support  array $productDiscountIds 组合优惠id 
     * @support  float $productDiscountDeductionMoney 组合优惠优惠金额 [Original type unsignedDouble] 
     * @support  int $channel 渠道号 
     * @support  int $gestationalWeek 孕周 
     * @support  string $note 备注 
     * @support  string $contact 联系人 
     * @support  string $platform 平台 
     * @support  array $detail 下单产品详情 
     * @support  array $retailDetail 下单零售产品产品详情 
     * @support  float $peopleDiscountMoney 人头优惠金额 [Original type unsignedDouble] 
     * @throws  \Exception
     * @return  array
     */
    public static function createOrder () {
        return self::getClass()->createOrder();
    }

    /**
     * 订单详情
     *
     * @support  string $orderNo 订单编号 
     * @support  int $orderId 订单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 团购订单详情
     *
     * @support  string $groupOrderNum 团购订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function groupOrderDetail () {
        return self::getClass()->groupOrderDetail();
    }

    /**
     * 加密订单详情
     *
     * @support  string $encodeOrderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function encodeOrderDetail () {
        return self::getClass()->encodeOrderDetail();
    }

    /**
     * 订单列表
     *
     * @support  string $status 订单状态- total:全部, wait:待拍摄, process:当日拍摄, complete:已完成, close:已关闭 [ require true ]
     * @support  int $page 页数 
     * @support  int $pageSize 分页数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 用户取消订单
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel () {
        return self::getClass()->cancel();
    }

    /**
     * 用户删除订单
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 绑定订单
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindUser () {
        return self::getClass()->bindUser();
    }

    /**
     * 订单退款.退礼品卡
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  array $reasonIds 退款原因ids 
     * @support  string $reason 退款原因 
     * @throws  \Exception
     * @return  mixed
     */
    public static function refund () {
        return self::getClass()->refund();
    }

    /**
     * 修改预约时间
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $reserveTime 新预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeReserveTime () {
        return self::getClass()->changeReserveTime();
    }

    /**
     * checkProductCalc
     *
     * @support  array $detail 产品详情 [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkProductCalc () {
        return self::getClass()->checkProductCalc();
    }

    /**
     * 退款理由
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRefundReason () {
        return self::getClass()->getRefundReason();
    }

    /**
     * 发送分享优惠券
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendOrderShareCoupon () {
        return self::getClass()->sendOrderShareCoupon();
    }

    /**
     * 创建订单.v1
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  string $userName 用户姓名 [ require true ]
     * @support  string $userPhone 用户手机号 [ require true ]
     * @support  string $userBirthday 用户生日 [ require true ]
     * @support  string $userSex 用户性别 [ require true ]
     * @support  string $userEmail 用户邮箱 
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  int $couponId 优惠券ID 
     * @support  float $couponDeductionMoney 优惠券优惠金额 [Original type unsignedDouble] 
     * @support  float $giftCardMoney 礼品卡抵扣金额 [Original type double] 
     * @support  float $oriMoney 原始价格 [Original type unsignedDouble] [ require true ]
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡优惠金额 [Original type unsignedDouble] 
     * @support  array $productDiscountIds 组合优惠id 
     * @support  float $productDiscountDeductionMoney 组合优惠优惠金额 [Original type unsignedDouble] 
     * @support  int $channel 渠道号 
     * @support  int $gestationalWeek 孕周 
     * @support  string $note 备注 
     * @support  string $contact 联系人 
     * @support  string $platform 平台 
     * @support  array $detail 下单产品详情 
     * @support  array $retailDetail 下单零售产品产品详情 
     * @support  float $peopleDiscountMoney 人头优惠金额 [Original type unsignedDouble] 
     * @throws  \Exception
     * @return  array
     */
    public static function createOrderV1 () {
        return self::getClass()->createOrderV1();
    }

    /**
     * 订单详情.v1
     *
     * @support  string $orderNo 订单编号 
     * @support  int $orderId 订单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function detailV1 () {
        return self::getClass()->detailV1();
    }

    /**
     * 订单列表.v1
     *
     * @support  string $status 订单状态- total:全部, submit:待支付, wait:待拍摄, process:当日拍摄, complete:已完成, close:已关闭 [ require true ]
     * @support  int $page 页数 
     * @support  int $pageSize 分页数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function listV1 () {
        return self::getClass()->listV1();
    }

    /**
     * 用户取消订单.v1
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelV1 () {
        return self::getClass()->cancelV1();
    }

    /**
     * 用户删除订单.v1
     *
     * @support  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteV1 () {
        return self::getClass()->deleteV1();
    }

    /**
     * 订单退款.v1
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  array $reasonIds 退款原因ids 
     * @support  string $reason 退款原因 
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundV1 () {
        return self::getClass()->refundV1();
    }

    /**
     * 修改预约时间.v1
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $reserveTime 新预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeReserveTimeV1 () {
        return self::getClass()->changeReserveTimeV1();
    }

    /**
     * 退款理由.v1
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRefundReasonV1 () {
        return self::getClass()->getRefundReasonV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatform', 'Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatform', 'Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}