<?php
namespace Mainto\Bridge\Invokes\AppointmentPlatformOld\RetailOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method retailOrderRefundByParams(array $params)
 * @method retailOrderRefundReasonByParams(array $params)
 * @method retailOrderRefundV1ByParams(array $params)
 * @method retailOrderRefundReasonV1ByParams(array $params)
 */
class RetailOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 零售退款
     *
     * @support  int $orderId 订单号 [ require true ]
     * @support  string $retailOrderNo 零售订单单号 [ require true ]
     * @support  int $storeId 预约门店ID [ require true ]
     * @support  string $refundReason 退款原因 [ require true ]
     * @support  string $userName 退款人 [ require true ]
     * @support  string $userAccount 退款支付宝账号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function retailOrderRefund () {
        return self::getClass()->retailOrderRefund([
        ]);
    }

    /**
     * 零售退款原因
     *
     * @throws  \Exception
     * @return  array
     */
    public static function retailOrderRefundReason () {
        return self::getClass()->retailOrderRefundReason();
    }

    /**
     * 零售退款V1
     *
     * @support  int $orderId 订单号 [ require true ]
     * @support  string $retailOrderNo 零售订单单号 [ require true ]
     * @support  int $storeId 预约门店ID [ require true ]
     * @support  string $refundReason 退款原因 [ require true ]
     * @support  string $userName 退款人 [ require true ]
     * @support  string $userAccount 退款支付宝账号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function retailOrderRefundV1 () {
        return self::getClass()->retailOrderRefundV1([
        ]);
    }

    /**
     * 零售退款原因v1
     *
     * @throws  \Exception
     * @return  array
     */
    public static function retailOrderRefundReasonV1 () {
        return self::getClass()->retailOrderRefundReasonV1();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('AppointmentPlatformOld', 'RetailOrder\RetailOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('AppointmentPlatformOld', 'RetailOrder\RetailOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}